<?php
// user_daily_inout_report.php: shows per-user In/Out with working hours summary

date_default_timezone_set('Asia/Kolkata');
$conn = new mysqli("localhost", "pavancom_bm", "Acer@123123", "pavancom_bm");
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

$dateFilter = $_GET['date'] ?? date('Y-m-d');
$userFilter = $_GET['user_id'] ?? '';
$deviceFilter = $_GET['device_id'] ?? '';
$page = max(1, intval($_GET['page'] ?? 1));
$limit = 20;
$offset = ($page - 1) * $limit;

$where = "WHERE DATE(regtime) = '" . $conn->real_escape_string($dateFilter) . "'";
if ($userFilter) $where .= " AND user_id = '" . $conn->real_escape_string($userFilter) . "'";
if ($deviceFilter) $where .= " AND device_id = '" . $conn->real_escape_string($deviceFilter) . "'";

if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=inout_summary.csv');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['User ID', 'Device ID', 'In Time', 'Out Time', 'Working Hours']);
    $export = $conn->query("SELECT user_id, device_id, MIN(regtime) AS in_time, MAX(regtime) AS out_time FROM log_data $where GROUP BY user_id, device_id ORDER BY user_id ASC");
    while ($r = $export->fetch_assoc()) {
        $in = strtotime($r['in_time']);
        $out = strtotime($r['out_time']);
        $diff = $out - $in;
        $h = floor($diff / 3600);
        $m = floor(($diff % 3600) / 60);
        $worked = sprintf('%02d:%02d Hrs', $h, $m);
        fputcsv($out, [$r['user_id'], $r['device_id'], $r['in_time'], $r['out_time'], $worked]);
    }
    fclose($out); exit;
}

if (isset($_GET['send_summary']) && $_GET['send_summary'] == 1) {
    function send_whatsapp_summary($msg) {
        $apiKey = "jGvypPi2hsXCUPIBN42zqyg5KSik7V";
        $sender = "919999999988";
        $receiver = "919908302604";
        $apiUrl = "https://whatsapplogin.pavancomputers.com/send-message?api_key=$apiKey&sender=$sender&number=$receiver&message=" . urlencode($msg);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_exec($ch);
        curl_close($ch);
    }
    $res = $conn->query("SELECT user_id, device_id, MIN(regtime) AS in_time, MAX(regtime) AS out_time FROM log_data $where GROUP BY user_id, device_id ORDER BY user_id ASC");
    $text = "\xf0\x9f\x93\x9d In/Out Summary (" . date('d-m-Y', strtotime($dateFilter)) . ")\n";
    while ($r = $res->fetch_assoc()) {
        $in = strtotime($r['in_time']);
        $out = strtotime($r['out_time']);
        $diff = $out - $in;
        $h = floor($diff / 3600);
        $m = floor(($diff % 3600) / 60);
        $text .= "\n\xf0\x9f\x91\xa4 {$r['user_id']} [{$r['device_id']}]\n\xe2\x9e\xa1\xef\xb8\x8f In: {$r['in_time']}\n\xe2\xac\x85\xef\xb8\x8f Out: {$r['out_time']}\n\xe2\x8f\xb1\xef\xb8\x8f {$h}h {$m}m";
    }
    send_whatsapp_summary($text);
    echo "<script>alert('Summary sent to WhatsApp');location.href='user_daily_inout_report.php';</script>";
    exit;
}

$result = $conn->query("SELECT user_id, device_id, MIN(regtime) AS in_time, MAX(regtime) AS out_time FROM log_data $where GROUP BY user_id, device_id ORDER BY user_id ASC LIMIT $limit OFFSET $offset");
$totalRows = $conn->query("SELECT COUNT(*) as total FROM (SELECT user_id FROM log_data $where GROUP BY user_id, device_id) as t")->fetch_assoc()['total'];
$totalPages = ceil($totalRows / $limit);
$users = $conn->query("SELECT DISTINCT user_id FROM log_data ORDER BY user_id ASC");
$devices = $conn->query("SELECT DISTINCT device_id FROM log_data ORDER BY device_id ASC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>In/Out Summary</title>
    <style>
        body { font-family: Arial; margin: 20px; }
        table { border-collapse: collapse; width: 100%; }
        th, td { padding: 10px; border: 1px solid #ccc; text-align: center; }
        th { background-color: #333; color: white; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        .btn { padding: 7px 14px; background: #222; color: white; text-decoration: none; margin: 5px; display: inline-block; }
        .missing { background: #ffe0e0; color: red; font-weight: bold; }
    </style>
    <script>
        let refreshOn = true;
        function toggleRefresh() {
            refreshOn = !refreshOn;
            document.getElementById("toggleRefresh").innerText = refreshOn ? "🔁 Auto-refresh ON" : "⏸️ Auto-refresh OFF";
        }
        setInterval(() => { if (refreshOn) location.reload(); }, 30000);
    </script>
</head>
<body>
<h2>📅 In/Out & Working Hours Summary <span id="toggleRefresh" onclick="toggleRefresh()" style="cursor:pointer; font-size:14px; color:blue;">🔁 Auto-refresh ON</span></h2>

<form method="get">
    <label>User:
        <select name="user_id">
            <option value="">All</option>
            <?php while ($u = $users->fetch_assoc()): ?>
                <option value="<?= $u['user_id'] ?>" <?= ($u['user_id'] == $userFilter) ? 'selected' : '' ?>><?= $u['user_id'] ?></option>
            <?php endwhile; ?>
        </select></label>
    <label>Device:
        <select name="device_id">
            <option value="">All</option>
            <?php while ($d = $devices->fetch_assoc()): ?>
                <option value="<?= $d['device_id'] ?>" <?= ($d['device_id'] == $deviceFilter) ? 'selected' : '' ?>><?= $d['device_id'] ?></option>
            <?php endwhile; ?>
        </select>
    </label>
    <label>Date: <input type="date" name="date" value="<?= htmlspecialchars($dateFilter) ?>"></label>
    <button type="submit" class="btn">Filter</button>
</form>
<a href="?export=csv&date=<?= urlencode($dateFilter) ?>&user_id=<?= urlencode($userFilter) ?>&device_id=<?= urlencode($deviceFilter) ?>" class="btn">📤 Export CSV</a>
<a href="?send_summary=1&date=<?= urlencode($dateFilter) ?>&user_id=<?= urlencode($userFilter) ?>&device_id=<?= urlencode($deviceFilter) ?>" class="btn" style="background:#007a2c">📱 WhatsApp Summary</a>

<table>
    <tr>
        <th>User ID</th><th>Device ID</th>
        <th>In Time</th>
        <th>Out Time</th>
        <th>Working Hours</th>
    </tr>
    <?php while ($row = $result->fetch_assoc()): 
        $in = strtotime($row['in_time']);
        $out = strtotime($row['out_time']);
        $diff = $out - $in;
        $hours = floor($diff / 3600);
        $minutes = floor(($diff % 3600) / 60);
        $missing = ($in == $out) ? 'missing' : '';
    ?>
    <tr class="<?= $missing ?>">
        <td><?= $row['user_id'] ?></td><td><?= $row['device_id'] ?></td>
        <td><?= $row['in_time'] ?></td>
        <td><?= $row['out_time'] ?></td>
        <td><?= sprintf('%02d:%02d Hrs', $hours, $minutes) ?></td>
    </tr>
    <?php endwhile; ?>
</table>

<div style="margin-top:15px;">
    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
        <a class="btn" href="?page=<?= $i ?>&date=<?= urlencode($dateFilter) ?>&user_id=<?= urlencode($userFilter) ?>&device_id=<?= urlencode($deviceFilter) ?>"><?= $i ?></a>
    <?php endfor; ?>
</div>

</body>
</html>