<?php
error_reporting(1);
date_default_timezone_set('Asia/Kolkata'); // Set IST timezone

include "config.php";

$header = apache_request_headers();	
$command = null;
$data = null;

// Log headers to file
file_put_contents('debug_file.txt', print_r($header, true), FILE_APPEND);

if (!$header["dev_id"]) 
    die("Not a Silicon Wireless Systems Face Device, No dev_id found in header");

$trans_data = new silicon_data;
$trans_data->appendfile = $header["dev_id"] . "_tmp.dat";

if (!$header["blk_no"]) 
    $header["blk_no"] = 0;

if ($header["blk_no"] == 0) {
    $input_valus = $trans_data->get();
    file_put_contents('debug_file.txt', print_r($input_valus, true), FILE_APPEND);

    $device_id = $header["dev_id"];

    // ✅ Log device command
    log_device_command($device_id, $header);

    // ✅ Process data by request_code
    switch ($header["request_code"]) {
        case "realtime_glog":
            insert_log_data($device_id, $input_valus);
            update_device_last_seen($device_id);
            break;

        case "realtime_enroll_data":
            break;

        case "receive_cmd":
            set_device($device_id, $input_valus);
            update_device_last_seen($device_id);
            break;

        default:
            break;
    }

    if (file_exists($trans_data->appendfile)) 
        unlink($trans_data->appendfile);
} else {
    $trans_data->append($header["blk_no"]);
}

// ✅ Respond to device
$trans_data->set($command, $data);

// 🔽 Update device last seen
function update_device_last_seen($device_id)
{
    global $dbh;
    if (!$device_id) return;

    try {
        $now = date('Y-m-d H:i:s'); // Indian time
        $stmt = $dbh->prepare("INSERT INTO device_status (device_id, last_seen)
                               VALUES (?, ?)
                               ON DUPLICATE KEY UPDATE last_seen = VALUES(last_seen)");
        $stmt->bindParam(1, $device_id);
        $stmt->bindParam(2, $now);
        $stmt->execute();
    } catch (PDOException $e) {
        file_put_contents("error_log.txt", "Device last seen update error: " . $e->getMessage() . PHP_EOL, FILE_APPEND);
    }
}

// 🧠 Log command details from device
function log_device_command($device_id, $header)
{
    global $dbh;

    try {
        $stmt = $dbh->prepare("
            INSERT INTO device_command_logs 
                (device_id, request_code, cmd_id, block_no, block_len, content_length) 
            VALUES (?, ?, ?, ?, ?, ?)
        ");

        $device_id      = $device_id ?? '';
        $request_code   = $header['request_code'] ?? '';
        $cmd_id         = $header['cmd_id'] ?? '';
        $blk_no         = $header['blk_no'] ?? 0;
        $blk_len        = $header['blk_len'] ?? 0;
        $content_length = $_SERVER['CONTENT_LENGTH'] ?? 0;

        $stmt->bindParam(1, $device_id);
        $stmt->bindParam(2, $request_code);
        $stmt->bindParam(3, $cmd_id);
        $stmt->bindParam(4, $blk_no);
        $stmt->bindParam(5, $blk_len);
        $stmt->bindParam(6, $content_length);
        $stmt->execute();

    } catch (PDOException $e) {
        file_put_contents("error_log.txt", "Command log error: " . $e->getMessage() . PHP_EOL, FILE_APPEND);
    }
}
?>
