<?php
// log_data_table.php with filters, auto-refresh, CSV export, WhatsApp summary

date_default_timezone_set('Asia/Kolkata');
$conn = new mysqli("localhost", "pavancom_bm", "Acer@123123", "pavancom_bm");
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

function send_whatsapp_summary($summaryText) {
    $apiKey = "jGvypPi2hsXCUPIBN42zqyg5KSik7V";
    $sender = "919999999988";
    $receiver = "919908302604";
    $encodedMessage = urlencode($summaryText);

    $apiUrl = "https://whatsapplogin.pavancomputers.com/send-message?api_key=$apiKey&sender=$sender&number=$receiver&message=$encodedMessage";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_exec($ch);
    curl_close($ch);
}

$dateFilter = $_GET['date'] ?? '';
$userFilter = $_GET['user_id'] ?? '';
$deviceFilter = $_GET['device_id'] ?? '';
$where = "WHERE 1=1";
if ($dateFilter) $where .= " AND DATE(regtime) = '" . $conn->real_escape_string($dateFilter) . "'";
if ($userFilter) $where .= " AND user_id = '" . $conn->real_escape_string($userFilter) . "'";
if ($deviceFilter) $where .= " AND device_id = '" . $conn->real_escape_string($deviceFilter) . "'";

if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=log_data.csv');
    $output = fopen('php://output', 'w');
    fputcsv($output, ['ID', 'User ID', 'IO Mode', 'Verify Mode', 'Reg Time', 'Valid', 'Device ID']);
    $result = $conn->query("SELECT * FROM log_data $where ORDER BY regtime DESC");
    while ($row = $result->fetch_assoc()) fputcsv($output, $row);
    fclose($output); exit;
}

if (isset($_GET['send_summary'])) {
    $res = $conn->query("SELECT device_id, COUNT(*) as total FROM log_data WHERE DATE(regtime) = CURDATE() GROUP BY device_id");
    $msg = "\xF0\x9F\x93\x8B Attendance Summary (" . date('d-m-Y') . ")\n";
    while ($r = $res->fetch_assoc()) {
        $msg .= "\n\xF0\x9F\x94\xB9 {$r['device_id']}: {$r['total']} logs";
    }
    send_whatsapp_summary($msg);
    echo "<script>alert('Summary sent');location.href='log_data_table.php';</script>";
    exit;
}

$result = $conn->query("SELECT * FROM log_data $where ORDER BY regtime DESC LIMIT 200");
$users = $conn->query("SELECT DISTINCT user_id FROM log_data ORDER BY user_id ASC");
$devices = $conn->query("SELECT DISTINCT device_id FROM log_data ORDER BY device_id ASC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Log Data Table</title>
    <style>
        body { font-family: Arial; margin: 20px; }
        h2 { color: #333; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 10px; border: 1px solid #ccc; }
        th { background-color: #333; color: white; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        .btn { padding: 7px 14px; background: #222; color: white; text-decoration: none; margin: 5px; display: inline-block; }
        .filters { margin-bottom: 20px; }
    </style>
</head>
<body>
<h2>📋 Attendance Log Data</h2>
<a href="?export=csv" class="btn">📤 Export CSV</a>
<a href="?send_summary=1" class="btn" style="background:#007a2c">📱 Send WhatsApp Summary</a>

<form class="filters" method="get">
    <label>User:
        <select name="user_id">
            <option value="">All</option>
            <?php while($u = $users->fetch_assoc()): ?>
                <option value="<?= $u['user_id'] ?>" <?= ($u['user_id'] == $userFilter) ? 'selected' : '' ?>><?= $u['user_id'] ?></option>
            <?php endwhile; ?>
        </select>
    </label>
    <label>Device:
        <select name="device_id">
            <option value="">All</option>
            <?php while($d = $devices->fetch_assoc()): ?>
                <option value="<?= $d['device_id'] ?>" <?= ($d['device_id'] == $deviceFilter) ? 'selected' : '' ?>><?= $d['device_id'] ?></option>
            <?php endwhile; ?>
        </select>
    </label>
    <label>Date: <input type="date" name="date" value="<?= htmlspecialchars($dateFilter) ?>"></label>
    <button type="submit" class="btn">Filter</button>
</form>

<table>
    <tr>
        <th>ID</th>
        <th>User ID</th>
        <th>IO Mode</th>
        <th>Verify Mode</th>
        <th>Reg Time</th>
        <th>Valid</th>
        <th>Device ID</th>
    </tr>
    <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td><?= $row['user_id'] ?></td>
            <td><?= $row['iomode'] ?></td>
            <td><?= $row['verifymode'] ?></td>
            <td><?= $row['regtime'] ?></td>
            <td><?= $row['valid'] ?></td>
            <td><?= $row['device_id'] ?></td>
        </tr>
    <?php endwhile; ?>
</table>

<script>
setTimeout(() => location.reload(), 15000);
</script>
</body>
</html>
