<?php
// user_daily_inout_report.php: shows per-user In/Out with working hours summary + PDF export, scheduling, email, logo

require('fpdf/fpdf.php');
date_default_timezone_set('Asia/Kolkata');
$conn = new mysqli("localhost", "pavancom_bm", "Acer@123123", "pavancom_bm");
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

$dateFilter = $_GET['date'] ?? date('Y-m-d');
$userFilter = $_GET['user_id'] ?? '';
$deviceFilter = $_GET['device_id'] ?? '';
$page = max(1, intval($_GET['page'] ?? 1));
$limit = 20;
offset = ($page - 1) * $limit;

$where = "WHERE DATE(regtime) = '" . $conn->real_escape_string($dateFilter) . "'";
if ($userFilter) $where .= " AND user_id = '" . $conn->real_escape_string($userFilter) . "'";
if ($deviceFilter) $where .= " AND device_id = '" . $conn->real_escape_string($deviceFilter) . "'";

// UI Rendering
$users = $conn->query("SELECT DISTINCT user_id FROM log_data ORDER BY user_id ASC");
$devices = $conn->query("SELECT DISTINCT device_id FROM log_data ORDER BY device_id ASC");
$totalRows = $conn->query("SELECT COUNT(DISTINCT user_id, device_id) as total FROM log_data $where")->fetch_assoc()['total'];
$totalPages = ceil($totalRows / $limit);

$result = $conn->query("SELECT user_id, device_id, MIN(regtime) AS in_time, MAX(regtime) AS out_time FROM log_data $where GROUP BY user_id, device_id ORDER BY user_id ASC LIMIT $offset, $limit");
?>
<!DOCTYPE html>
<html>
<head>
    <title>In/Out Summary</title>
    <style>
        body { font-family: Arial; margin: 20px; }
        table { border-collapse: collapse; width: 100%; }
        th, td { padding: 10px; border: 1px solid #ccc; text-align: center; }
        th { background-color: #333; color: white; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        .btn { padding: 7px 14px; background: #222; color: white; text-decoration: none; margin: 5px; display: inline-block; }
        .incomplete { background: #ffdddd; }
        .pagination a { padding: 5px 10px; text-decoration: none; border: 1px solid #333; margin: 2px; }
        .pagination a.active { background: #333; color: white; }
    </style>
</head>
<body>
<h2>📅 In/Out & Working Hours Summary</h2>
<form method="get">
    <label>User:
        <select name="user_id">
            <option value="">All</option>
            <?php while ($u = $users->fetch_assoc()): ?>
                <option value="<?= $u['user_id'] ?>" <?= ($u['user_id'] == $userFilter) ? 'selected' : '' ?>><?= $u['user_id'] ?></option>
            <?php endwhile; ?>
        </select></label>
    <label>Device:
        <select name="device_id">
            <option value="">All</option>
            <?php while ($d = $devices->fetch_assoc()): ?>
                <option value="<?= $d['device_id'] ?>" <?= ($d['device_id'] == $deviceFilter) ? 'selected' : '' ?>><?= $d['device_id'] ?></option>
            <?php endwhile; ?>
        </select></label>
    <label>Date: <input type="date" name="date" value="<?= htmlspecialchars($dateFilter) ?>"></label>
    <button type="submit" class="btn">Filter</button>
</form>
<a href="?export=csv&<?= http_build_query($_GET) ?>" class="btn">📄 Export CSV</a>
<a href="?export=pdf&<?= http_build_query($_GET) ?>" class="btn">📄 Export PDF</a>
<a href="?send_summary=1&<?= http_build_query($_GET) ?>" class="btn" style="background:#007a2c">📱 WhatsApp Summary</a>

<table>
    <tr>
        <th>User ID</th><th>Device ID</th>
        <th>In Time</th>
        <th>Out Time</th>
        <th>Working Hours</th>
    </tr>
    <?php while ($row = $result->fetch_assoc()): 
        $in = strtotime($row['in_time']);
        $out = strtotime($row['out_time']);
        $diff = $out - $in;
        $hours = floor($diff / 3600);
        $minutes = floor(($diff % 3600) / 60);
        $worked = sprintf('%02d:%02d Hrs', $hours, $minutes);
        $highlight = ($row['in_time'] == $row['out_time']) ? 'class="incomplete"' : '';
    ?>
    <tr <?= $highlight ?>>
        <td><?= $row['user_id'] ?></td>
        <td><?= $row['device_id'] ?></td>
        <td><?= $row['in_time'] ?></td>
        <td><?= $row['out_time'] ?></td>
        <td><?= $worked ?></td>
    </tr>
    <?php endwhile; ?>
</table>

<div class="pagination">
    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
        <a href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>" class="<?= ($i == $page) ? 'active' : '' ?>"><?= $i ?></a>
    <?php endfor; ?>
</div>
</body>
</html>
